<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ObservationCreated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */

    public $libelle;
    public $dps_id;
    public $centre_id;
    public $user_id;
    public $type;

    public function __construct($libelle, $dps_id, $centre_id, $user_id, $type)
    {
        $this->libelle = $libelle;
        $this->dps_id = $dps_id;
        $this->centre_id = $centre_id;
        $this->user_id = $user_id;
        $this->type = $type;
    }


    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('gas');
    }

    public function broadcastAs()
    {
        return 'gas_event';
    }
}
